

/******************************************************************************************
 *                                                                                        *
 * Ex.3 :  Application Read BCD Touch key Out data to LCD(Use ET-BASE PIC8722(ICD2))      *
 *        (Format:Press key Shift + Key Other                                             *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
  * Target MCU       : PIC18F8722 (ET-BASE PIC8722(ICD2))                                 *
 *                   : X-TAL : 10 MHz                                                     *
 *                   : CPU Clock = 40 MHz (x4)                                            *  
 *                                                                                        *
 * Editor-Compiler   : CCS Version 4.124                                                  *
 *                                                                                        *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                               *
 * Last Update       : 10/September/2014                                                  *
 *                                                                                        *
 * Port Interface    :  -- MCU-PIC-18F8722--                  -- Key Touch PAD 4x4 --     *
 *                                                                                        *
 *                     PJ0(Input)          Connect                 BCD Colum 1            * 
 *                     PJ1(Input)          Connect                 BCD Colum 2            *
 *                     PJ2(Input)          Connect                 BCD Colum 4            *
 *                     PJ3(Input)          Connect                 BCD Colum 8            *
 *                     PJ4(Input)          Connect                 T#/R Ststus 1Key       *
 *                     PJ5(Input)          Connect                 SHIF# Statu 2Key       *
 *                                                                                        *
 *                                                                                        *
 *           LCD     : Connect 4bit data ;LCD 16x2 by        ----LCD 16x2-----            *
 *                     RH1(output)         Connect         RS                             *
 *                     RH2(output)         Connect         R/W                            *
 *                     RH3(output)         connect         E                              *
 *                     RH4-RH7(output)     connect         Data 4 bit high                *
 *                                                                                        *
 *                                                                                        *
 *       5V                                                                               *
 *      --+--                                                                             *
 *        |                                                                               *
 *        +-----------------+                                                             *
 *        |                 |                                                             *
 *       ---                |                                                             *
 *       |\|                |                                                             *
 *    VR |/|<---------------|--+                                                          *
 *   10K ---                |  |  RH1 RH2 RH3           RH4   RH5    RH6    RH7           *
 *        |                 |  |   ^   ^  ^              ^     ^      ^      ^            *
 *        |                 |  |   |   |  |              |     |      |      |            *
 *        +--------------+--|--|---|---|--|--+--+--+--+  |     |      |      |            *
 *      __|__            |  |  |   |   |  |  |  |  |  |  |     |      |      |            *
 *       ---             |  |  |   |   |  |  |  |  |  |  |     |      |      |            *
 *        -             1| 2| 3|  4|  5| 6| 7| 8| 9|10|11|   12|    13|    14|            *
 *                     __|__|__|___|___|__|__|__|__|__|__|___ _|___ __|___ __|_           *
 *                    |  G Vcc Vo RS  R/W E D0 D1 D2 D3 D4    D5      D6    D7 |          *
 *                    |      _____________________________________________     |          *
 *                    |     |                                             |    |          *
 *                    |     |                 Module                      |    |          *
 *                    |     |           LCD 2x16 Charecter                |    |          *  
 *                    |     |_____________________________________________|    |          *
 *                    |                                                        |          *
 *                    |________________________________________________________|          *
 *                                                                                        *                                                                                           *
 *                                                                                        *
 *                                                                                        *
 ******************************************************************************************/
 
#include <18F8722.h>
#include <stdio.h>

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN         //Setup MCU
#use delay (clock = 40000000)                    //delay Clock = (ms)

#use fast_io(ALL)                                //Stop Set direction Auto for All Port  by Compiler  


//---------------Key Function ---------------

int8 Check_SHIF(void)   ;
int8 Check_TR(void)     ;
int8 RD_KeyCode(void)   ;


//------------------LCD Function ------------------
void init_lcd(void)                   ;                // Function Initial LCD
void write_ins(unsigned int8 cmm)     ;                // Function write Command LCD
void write_data(unsigned int8 dat)    ;                // Function write data LCD
void gotolcd(unsigned int8 p)         ;                // Function Write position Curser
void EN_LCD()                         ;                // Function Enable Clock


//*************************** Main *************************

void main (void) 
    {                               
  
     int8 key,k ;
     int8 message[] = {"ET-TOUCH PAD 4x4"} ;
     int8     ms1[] = {" Not!Touch Key! "} ;
     int8     ms2[] = {"Touch Key  = "}    ;  
     int8     ms3[] = {"Touch Key:SH+"}   ;                            

     
     //------------- Initial Port -----------
     
      set_tris_H(0x00)                ;        //Set RH(0..7) = Output for LCD Display  
      set_tris_J(0xFF)                ;        //Set RJ(0..7) = Input for Read BCD Key Code
          
      OUTPUT_H(0x00)                  ;        //Set data 0x00 Default RH
      
    //---------------- Main -----------------
    
      init_lcd()                              ;  //Initial LCD 
      
      gotolcd(0x00)                           ;  //Start Position data on LCD
      for(k=0;k<16;k++)
        write_data(message[k])                ;  //Sent data to LCD
   
      gotolcd(0x40)                           ;  //Start Position data on LCD
      for(k=0;k<16;k++)                          
        write_data(ms1[k])                    ;  //Sent Message "Not!Touch Button" to LCD
      

      while(true)
       {
        if(!Check_TR())                            //Step1: Check  Touch key (Check_TR()=0:Touch,1:release) 
         {
           key  = RD_KeyCode()                ;    //Step2: Read Key Code

           if( key == 0x0F)                        //Step3: Check Touch Key Shift(Touch the 1st Key) is Touch 2 Key
            {
              do
              {
                if(!Check_SHIF())                 //Step3.1 : Check Touch Key Other(Touch the 2nd Key) by 0:touch,1: not touch
                 {                   
                   key = RD_KeyCode()        ;    //Step 3.2: Read Key Code for Key Shif+Key Other

                  //---------- Step3.3:Program Respond Touch 2key for user(SHIF+Key) ------------
             
                   switch(key)
                    {
                      case 0x01 :   //Shif+Key#1

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD   
                                  write_data('"')                 ;            
                                  write_data('1')                 ; 
                                  write_data('"')                 ; 
                              
                                  break;

                       case 0x02 :   //Shif+Key#2

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD   
                                  write_data('"')                 ;    
                                  write_data('2')                 ; 
                                  write_data('"')                 ; 
                              
                                  break;

                       case 0x03 :   //Shif+Key#3

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD              
                                  write_data('"')                 ; 
                                  write_data('3')                 ; 
                                  write_data('"')                 ; 
                              
                                  break;


                       case 0x04 :   //Shif+Key#4

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD      
                                  write_data('"')                 ;         
                                  write_data('4')                 ; 
                                  write_data('"')                 ; 
                              
                                  break;

                       case 0x05 :   //Shif+Key#5

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD      
                                  write_data('"')                 ;         
                                  write_data('5')                 ; 
                                  write_data('"')                 ; 
                              
                                  break;


                        case 0x06 :   //Shif+Key#6

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD      
                                  write_data('"')                 ;             
                                  write_data('6')                 ; 
                                  write_data('"')                 ; 
                              
                                  break;


                        case 0x07 :   //Shif+Key#7

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD      
                                  write_data('"')                 ;             
                                  write_data('7')                 ; 
                                  write_data('"')                 ; 
                              
                                  break;


                        case 0x08 :   //Shif+Key#8

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD   
                                  write_data('"')                 ;         
                                  write_data('8')                 ; 
                                  write_data('"')                 ; 
                              
                                  break;


                        case 0x09 :   //Shif+Key#9

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD      
                                  write_data('"')                 ;         
                                  write_data('9')                 ;
                                  write_data('"')                 ; 
                              
                                  break;

                        case 0x00 :   //Shif+Key#0

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD          
                                  write_data('"')                 ;     
                                  write_data('0')                 ; 
                                  write_data('"')                 ; 
                              
                                  break;

                    }//switch
                     
                    while(!Check_SHIF()){;}                       ;  //Wait Release 2Key (=1 exit loop)
              
                    gotolcd(0x40)                                 ;  //Start Position data on LCD
                    for(k=0;k<16;k++)                          
                      write_data(ms1[k])                          ;  //Sent Message "Not!Touch Button" to LCD
                
                 } //if Check Shif
                                                
               }while(!Check_TR())                                ;   //Loop wait Touch the 2nd Key , Exit loop When release Key Shif or 2Key      

            }   //if key == 0x0F
          else                                   //Step4: Check Touch Key Other don't key Shift is Touch 1 Key
            { 
              //---------- Step4.1:Program Respond Touch 1 key for user ------------
       
                switch(key)
                  {
                     case 0x01 :   //Key#1

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('1')                 ; 
                                write_data('"')                 ; 
                      
                                break;

                     case 0x02 :   //Key#2

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('2')                 ; 
                                write_data('"')                 ; 
                      
                                break;


                     case 0x03 :   //Key#3

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('3')                 ; 
                                write_data('"')                 ; 
                    
                                break;

                     case 0x04 :   //Key#4

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('4')                 ; 
                                write_data('"')                 ; 
                      
                                break;


                     case 0x05 :  //Key#5

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('5')                 ; 
                                write_data('"')                 ; 
                       
                                break;


                     case 0x06 :   //Key#6

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('6')                 ; 
                                write_data('"')                 ; 
                     
                                break;

                     case 0x07 :   //Key#7

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('7')                 ; 
                                write_data('"')                 ; 
                     
                                break;

                     case 0x08 :   //Key#8

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('8')                 ; 
                                write_data('"')                 ; 
                       
                                break;

                     case 0x09 :   //Key#9

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('9')                 ; 
                                write_data('"')                 ; 
                      
                                break;

                     case 0x00 :  //Key#0

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD              
                                write_data('"')                 ;  
                                write_data('0')                 ; 
                                write_data('"')                 ; 
                     
                                break;

                     case 0x0A :  //Key#A(Clear)

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD
              
                                write_data('"')                 ;  
                                write_data('A')                 ; 
                                write_data('"')                 ; 
                      
                                break;

                     case 0x0B :   //Key#B

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD
                                write_data('"')                 ;  
                                write_data('B')                 ; 
                                write_data('"')                 ; 
                      
                                break;


                     case 0x0C :   //Key#C

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD
                                write_data('"')                 ;  
                                write_data('C')                 ; 
                                write_data('"')                 ; 
                      
                                break;


                     case 0x0D :  //Key#D

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD
              
                                write_data('"')                 ;  
                                write_data('D')                 ; 
                                write_data('"')                 ; 
                      
                                break;

                     case 0x0E :   //Key#E

                                gotolcd(0x40)                   ;  //Start Position data on LCD
                                for(k=0;k<13;k++)
                                  write_data(ms2[k])            ;  //Sent data to LCD
                                write_data('"')                 ;  
                                write_data('E')                 ; 
                                write_data('"')                 ; 
                     
                                break;

                  }//Switch
         
                  while(!Check_TR()){;}                             ;   //Wait Release Key (=1 exit loop)    
       
                  gotolcd(0x40)                                     ;  //Start Position data on LCD
                  for(k=0;k<16;k++)                         
                    write_data(ms1[k])                              ;  //Sent Message "Not!Touch Button" to LCD
            } //else
     
         }     //if Check_TR
     }      //while      
   }




//********************** Sub Program *************************


//------------ Check Touch /Release for 2Key ----------------

int8 Check_SHIF(void)   
{
   int8 sh   ;
        
    sh  = INPUT_J()               ;   //Read Status Key
    sh  = sh & 0x20               ;   //Mark bit PJ5 (Statust Press or Release : 2Key)
   
    if(sh != 0x20)                    //Check Statue Key
      return (0)                 ;    //Touch 2Key Return 0 (PJ5=0)
    else
       return (1)                ;    //Release Key Return 1(PJ5=1)


}
//------------- Check Touch /Release Key --------------------

int8 Check_TR(void)    
 {
   int8 tr   ;
        
      tr  = INPUT_J()             ;   //Read Status Key
      tr  = tr & 0x10             ;   //Mark bit PJ4 (Statust Press or Release)
   
    if(tr != 0x10)                    //Check Statue Key
      return (0)                 ;    //Touch Key Return 0 (PJ4=0)
    else
       return (1)                ;    //Release Key Return 1   (PJ4=1)
 }


//---------- Read BCD Key Code -----------------

 int8 RD_KeyCode(void) 
  {
    unsigned int8 KeyCode                  ;
  
    KeyCode      = INPUT_J()               ;   //Read Key Code
    KeyCode      = KeyCode & 0x0F          ;   //Mark bit PJ0-PJ3(Key Code 4 bit)
    return (KeyCode)                       ;
  }




//<<<<<<<<<<<<<<<<<<<---- LCD SUB ---->>>>>>>>>>>>>>>>>>>>>>

//---------- Initial LCD -----------

void init_lcd(void)
 {
  write_ins(0x33)              ;  //CMM Function Set
  write_ins(0x32)              ;  //CMM Function set
  write_ins(0x28)              ;  //CMM Function Set :DL(0)=4bit LCD ,N(1)=2 Line,F(0)= font 5x7 dot

  write_ins(0x0C)              ;  //CMM Display On/OFF :D=1,Display On
  write_ins(0x06)              ;  //CMM Entry :I/D(1)= DD RAM Address Increment,S(0) Cursor Shift
  write_ins(0x01)              ;  //CMM Clear Display
  gotolcd(0x00)                ;  //Start Address 00
 }

 //------- Enable LCD -------
 void EN_LCD()
  {
    OUTPUT_HIGH(PIN_H3)   ;  //RH3 =En = 1   
    delay_ms(1)           ;
    OUTPUT_LOW(PIN_H3)    ;  //RH3 =En = 0
    delay_ms(1)           ;
 }


//----------- Write Instruction LCD Command ------------

void write_ins(unsigned int8 cmm)
 {
  unsigned int8 com ;
  
   com = cmm & 0xF0          ; // Clear Command 4 bit Low and RS(RH1),RW(RH2)=0
   OUTPUT_H(com )            ; // Sent Command 4 Bit High to RH4..RH7
   EN_LCD()                  ; // Enable LCD
   delay_ms(3)               ;
   
   cmm = (cmm<<4) & 0xF0     ; //Shift cmm 4 bit Low to 4bit High and RS(RH1),RW(RH2)=0
   OUTPUT_H(cmm)             ; // Sent Command 4 Bit Low to RH4..RH7
   EN_LCD()                  ; // Enable LCD
   delay_ms(3)               ;

 }

//----------- Write Data LCD Command ------------

 void write_data(unsigned int8 dat)
  {
    unsigned int8 dtt ;     
  
   dtt = (dat & 0xF0)|0x02       ; //Clear data 4 bit Low and RS(RH1)=1,RW(RH2)=0
   OUTPUT_H(dtt )                ; //Sent data 4 Bit High to RH4..RH7
   EN_LCD()                      ; //Enable LCD
   delay_ms(3)                   ;
   
   dat = ((dat<<4) & 0xF0)|0x02  ; //Shift data 4 bit Low to 4bit High and RS(RH1)=1,RW(RH2)=0
   OUTPUT_H(dat)                 ; //Sent data 4 Bit Low to RH4..RH7
   EN_LCD()                      ; //Enable LCD
   delay_ms(3)                   ;

  }

//------------ Move Cursor LCD ------------

void gotolcd(unsigned int8 p)
 {
   p |= 0x80    ;
   write_ins(p) ;
 }





